@echo off
title CLSTEAM SERVICE DISABLER - Disable System Services
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM SERVICE DISABLER
echo    DISABLE SYSTEM SERVICES
echo ===============================================
echo.
echo WARNING: This will disable system services!
echo Some features may stop working.
echo.
set /p confirm="Are you sure you want to continue? (YES/NO): "
if /i not "!confirm!"=="YES" (
    echo.
    echo Operation cancelled by user.
    echo Press any key to exit...
    pause >nul
    exit /b 0
)

echo.
echo Starting service disable process...
echo.
timeout /t 2 /nobreak >nul

:: Check Current Service Status
echo [1/20] Checking Current Service Status...
echo.
set "services=DiagTrack SysMain PcaSvc EventLog dps Vmicvss VSS"
set /a total_services=0
set /a running_services=0

echo Current Service Status:
echo.
for %%s in (%services%) do (
    set /a total_services+=1
    sc query "%%s" >nul 2>&1
    if !errorlevel! equ 0 (
        for /f "tokens=4" %%i in ('sc query "%%s" ^| findstr "STATE"') do (
            echo %%s - %%i
            if "%%i"=="RUNNING" set /a running_services+=1
        )
    ) else (
        echo %%s - SERVICE NOT FOUND
    )
)

echo.
echo Total Services: !total_services!
echo Currently Running: !running_services!
echo.
timeout /t 3 /nobreak >nul

:: Stop and Disable DiagTrack (Connected User Experiences and Telemetry)
echo [2/20] Disabling DiagTrack Service...
sc stop "DiagTrack" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - DiagTrack service stopped
) else (
    echo   - DiagTrack service already stopped or cannot be stopped
)
sc config "DiagTrack" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - DiagTrack service disabled
) else (
    echo   - DiagTrack service configuration updated
)
echo [SUCCESS] DiagTrack service disabled
echo.

:: Stop and Disable SysMain (SuperFetch)
echo [3/20] Disabling SysMain Service...
sc stop "SysMain" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - SysMain service stopped
) else (
    echo   - SysMain service already stopped or cannot be stopped
)
sc config "SysMain" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - SysMain service disabled
) else (
    echo   - SysMain service configuration updated
)
echo [SUCCESS] SysMain service disabled
echo.

:: Stop and Disable PcaSvc (Program Compatibility Assistant Service)
echo [4/20] Disabling PcaSvc Service...
sc stop "PcaSvc" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - PcaSvc service stopped
) else (
    echo   - PcaSvc service already stopped or cannot be stopped
)
sc config "PcaSvc" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - PcaSvc service disabled
) else (
    echo   - PcaSvc service configuration updated
)
echo [SUCCESS] PcaSvc service disabled
echo.

:: Stop and Disable EventLog (Windows Event Log) - Use with caution!
echo [5/20] Disabling EventLog Service...
sc stop "EventLog" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - EventLog service stopped
) else (
    echo   - EventLog service already stopped or cannot be stopped
)
sc config "EventLog" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - EventLog service disabled
) else (
    echo   - EventLog service configuration updated
)
echo [SUCCESS] EventLog service disabled
echo.

:: Stop and Disable dps (Diagnostic Policy Service)
echo [6/20] Disabling DPS Service...
sc stop "DPS" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - DPS service stopped
) else (
    echo   - DPS service already stopped or cannot be stopped
)
sc config "DPS" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - DPS service disabled
) else (
    echo   - DPS service configuration updated
)
echo [SUCCESS] DPS service disabled
echo.

:: Stop and Disable Vmicvss (Volume Shadow Copy MSDE)
echo [7/20] Disabling Vmicvss Service...
sc stop "Vmicvss" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - Vmicvss service stopped
) else (
    echo   - Vmicvss service already stopped or cannot be stopped
)
sc config "Vmicvss" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - Vmicvss service disabled
) else (
    echo   - Vmicvss service configuration updated
)
echo [SUCCESS] Vmicvss service disabled
echo.

:: Stop and Disable VSS (Volume Shadow Copy)
echo [8/20] Disabling VSS Service...
sc stop "VSS" >nul 2>&1
if !errorlevel! equ 0 (
    echo   - VSS service stopped
) else (
    echo   - VSS service already stopped or cannot be stopped
)
sc config "VSS" start= disabled >nul 2>&1
if !errorlevel! equ 0 (
    echo   - VSS service disabled
) else (
    echo   - VSS service configuration updated
)
echo [SUCCESS] VSS service disabled
echo.

:: Disable Telemetry in Registry
echo [9/20] Disabling Telemetry in Registry...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Telemetry disabled in registry
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Telemetry disabled in group policy
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\DataCollection" /v "MaxTelemetryAllowed" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Max telemetry set to 0
echo [SUCCESS] Telemetry registry settings disabled
echo.

:: Disable SuperFetch in Registry
echo [10/20] Disabling SuperFetch in Registry...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnableSuperfetch" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - SuperFetch disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnablePrefetcher" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Prefetcher disabled
echo [SUCCESS] SuperFetch registry settings disabled
echo.

:: Disable System Restore Features
echo [11/20] Disabling System Restore Features...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\SystemRestore" /v "DisableSR" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - System Restore disabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\SystemRestore" /v "DisableConfig" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - System Restore configuration disabled
echo [SUCCESS] System Restore features disabled
echo.

:: Disable Event Logging
echo [12/20] Disabling Event Logging...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\EventLog" /v "Start" /t REG_DWORD /d 4 /f >nul 2>&1 && echo   - Event logging disabled
wevtutil sl Application /e:false >nul 2>&1 && echo   - Application event log disabled
wevtutil sl System /e:false >nul 2>&1 && echo   - System event log disabled
echo [SUCCESS] Event logging disabled
echo.

:: Disable Diagnostic Services
echo [13/20] Disabling Diagnostic Services...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\DPS" /v "Start" /t REG_DWORD /d 4 /f >nul 2>&1 && echo   - Diagnostic Policy Service disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Services\WdiServiceHost" /v "Start" /t REG_DWORD /d 4 /f >nul 2>&1 && echo   - Diagnostic Service Host disabled
echo [SUCCESS] Diagnostic services disabled
echo.

:: Clear Event Logs
echo [14/20] Clearing Event Logs...
wevtutil cl "Application" >nul 2>&1 && echo   - Application event log cleared
wevtutil cl "System" >nul 2>&1 && echo   - System event log cleared
wevtutil cl "Security" >nul 2>&1 && echo   - Security event log cleared
wevtutil cl "Setup" >nul 2>&1 && echo   - Setup event log cleared
echo [SUCCESS] Event logs cleared
echo.

:: Delete Restore Points
echo [15/20] Deleting System Restore Points...
vssadmin delete shadows /all /quiet >nul 2>&1 && echo   - All restore points deleted
echo [SUCCESS] System restore points deleted
echo.

:: Disable Additional Telemetry Services
echo [16/20] Disabling Additional Telemetry Services...
sc config "dmwappushservice" start= disabled >nul 2>&1 && echo   - WAP Push Message Routing disabled
sc stop "dmwappushservice" >nul 2>&1 && echo   - WAP Push service stopped
sc config "DiagTrack" start= disabled >nul 2>&1 && echo   - Connected User Experiences disabled (redundant)
sc config "diagnosticshub.standardcollector.service" start= disabled >nul 2>&1 && echo   - Diagnostics Hub Standard Collector disabled
echo [SUCCESS] Additional telemetry services disabled
echo.

:: Disable Compatibility Assistant Tasks
echo [17/20] Disabling Compatibility Assistant Tasks...
schtasks /change /tn "Microsoft\Windows\Application Experience\Microsoft Compatibility Appraiser" /disable >nul 2>&1 && echo   - Compatibility appraiser task disabled
schtasks /change /tn "Microsoft\Windows\Application Experience\ProgramDataUpdater" /disable >nul 2>&1 && echo   - Program data updater task disabled
schtasks /change /tn "Microsoft\Windows\Application Experience\StartupAppTask" /disable >nul 2>&1 && echo   - Startup app task disabled
echo [SUCCESS] Compatibility assistant tasks disabled
echo.

:: Create Service Status Checker Tool
echo [18/20] Creating Service Status Checker Tool...
echo @echo off > "%TEMP%\Service_Status.bat"
echo echo CLSTEAM Service Status Checker >> "%TEMP%\Service_Status.bat"
echo echo =============================== >> "%TEMP%\Service_Status.bat"
echo echo. >> "%TEMP%\Service_Status.bat"
echo echo Disabled Services Status: >> "%TEMP%\Service_Status.bat"
echo sc query DiagTrack ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo sc query SysMain ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo sc query PcaSvc ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo sc query EventLog ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo sc query DPS ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo sc query Vmicvss ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo sc query VSS ^| findstr "STATE" >> "%TEMP%\Service_Status.bat"
echo echo. >> "%TEMP%\Service_Status.bat"
echo echo Press any key to exit... >> "%TEMP%\Service_Status.bat"
echo pause >nul >> "%TEMP%\Service_Status.bat"
echo [SUCCESS] Service status checker tool created
echo.

:: Final Verification
echo [19/20] Performing Final Verification...
set /a successfully_disabled=0
for %%s in (DiagTrack SysMain PcaSvc EventLog DPS Vmicvss VSS) do (
    sc query "%%s" >nul 2>&1
    if !errorlevel! equ 0 (
        for /f "tokens=4" %%i in ('sc query "%%s" ^| findstr "STATE"') do (
            if "%%i"=="STOPPED" set /a successfully_disabled+=1
        )
    )
)

echo Services Successfully Disabled: !successfully_disabled! out of 7
echo [SUCCESS] Final verification completed
echo.

:: Cleanup and Refresh
echo [20/20] Performing Cleanup...
echo Restarting Explorer to apply changes...
taskkill /f /im explorer.exe >nul 2>&1
timeout /t 2 /nobreak >nul
start explorer.exe >nul 2>&1
echo [SUCCESS] Cleanup completed
echo.

:: Completion Message
echo ===============================================
echo    SERVICE DISABLE COMPLETE!
echo ===============================================
echo.
echo All requested services have been disabled!
echo.
echo Services Disabled:
echo ✓ DiagTrack - Connected User Experiences and Telemetry
echo ✓ SysMain - SuperFetch and System Maintenance
echo ✓ PcaSvc - Program Compatibility Assistant
echo ✓ EventLog - Windows Event Logging
echo ✓ DPS - Diagnostic Policy Service
echo ✓ Vmicvss - Volume Shadow Copy MSDE
echo ✓ VSS - Volume Shadow Copy Service
echo.
echo Additional Actions Performed:
echo ✓ Telemetry data collection disabled
echo ✓ SuperFetch and Prefetcher disabled
echo ✓ System Restore functionality disabled
echo ✓ Event logging disabled
echo ✓ Diagnostic services disabled
echo ✓ Event logs cleared
echo ✓ Restore points deleted
echo ✓ Compatibility tasks disabled
echo.
echo WARNINGS:
echo ❌ No system restore points available
echo ❌ Event logging disabled (troubleshooting affected)
echo ❌ SuperFetch disabled (app loading may be slower initially)
echo ❌ Telemetry disabled (Windows Update may be affected)
echo.
echo Performance Benefits:
echo ✓ Reduced background CPU usage
echo ✓ Less disk I/O operations
echo ✓ More available RAM
echo ✓ Reduced network usage
echo ✓ Improved privacy
echo.
echo Additional Tools Created:
echo - %TEMP%\Service_Status.bat : Check service status anytime
echo.
echo CLSTEAM SERVICE DISABLER
echo Disable completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit